terraform {
  required_version = ">= 1.0.0, < 2.0.0"

  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 4.0"
    }
  }
}

provider "aws" {
  region = "us-east-2"
}

# To był stary identyfikator dla grupy bezpieczeństwa. Poniżej mamy tę samą
# grupę bezpieczeństwa, ale z nowym identyfikatorem.
# resource "aws_security_group" "instance" {
#   name = var.security_group_name
# }

resource "aws_security_group" "cluster_instance" {
  name = var.security_group_name
}

# Automatyczne uaktualnienie stanu w celu obsługi zmienionego identyfikatora
# grupy bezpieczeństwa.
moved {
  from = aws_security_group.instance
  to   = aws_security_group.cluster_instance
}
